/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnPreDamaged;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DodgeEnchantment
extends CustomEnchantment {
    public DodgeEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.ARMOR_LEGS).slots(EquipmentSlots.LEGS).maxLevel(2).minLevelCost(level -> level * 14).maxLevelCost(level -> level * 14 + 20);
    }

    @AutoInstance
    public static class Handler {
        final DoubleConfig chance = new DoubleConfig(0.125, new Range((Number)0.01, (Number)0.5));
        final Supplier<DodgeEnchantment> enchantment = Registries.DODGE;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Dodge").comment("Gives a chance to completely avoid any kind of damage.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnPreDamaged.listen(this::dodgeDamage).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.target)).addCondition(OnPreDamaged.dealtAnyDamage()).addCondition(OnPreDamaged.willTakeFullDamage()).addCondition(Condition.predicate(data -> data.attacker != null)).addCondition(Condition.predicate(this::tryToDodge)).addConfig((IConfigurable)this.chance.name("chance").comment("Chance to completely ignore the damage per enchantment level.")).insertTo(group);
        }

        private void dodgeDamage(OnPreDamaged.Data data) {
            Level level = data.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                this.spawnEffects(data.target, level2);
            }
            OnPreDamaged.CANCEL.accept(data);
        }

        private void spawnEffects(LivingEntity entity, ServerLevel level) {
            for (double d = 0.0; d < 3.0; d += 1.0) {
                Vec3 position = new Vec3(0.0, (double)entity.m_20206_() * 0.25 * (d + 1.0), 0.0).m_82549_(entity.m_20182_());
                for (int i = 0; i < 2; ++i) {
                    level.m_8767_((ParticleOptions)((SimpleParticleType)Registries.DODGE_PARTICLE.get()), position.f_82479_, position.f_82480_, position.f_82481_, 5 * (2 * i + 1), (double)(i + 1) * 0.25, 0.375, (double)(i + 1) * 0.25, 0.0075);
                }
            }
            SoundHandler.FIRE_EXTINGUISH.play((Level)level, entity.m_20182_());
        }

        private boolean tryToDodge(OnPreDamaged.Data data) {
            return Random.tryChance((double)((double)this.enchantment.get().getEnchantmentLevel(data.target) * (Double)this.chance.get()));
        }
    }
}

